
{REDUND_ERROR} FUNCTION_BLOCK PMC_6DMotion (*Move single xbot in 6 degrees of freedom (fixed velocity)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y position in meters	*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* Z position in meters*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* rotation about the X axis in radians*)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* rotation about the Y axis in radians*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* rotation about the Z axis in radians*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT := 0; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2832;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_6DMotionVelocity (*Move single xbot in 6 degrees of freedom (user set velocity*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		TargetPos : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* [x,y,z,rx,ry,rz] in meters for position, in radians for rotation*)
		LongAxisAccVel : {REDUND_UNREPLICABLE} ARRAY[0..1] OF REAL; (* [long axis accel,long axis vel] meters/second^2, meters/second*)
		ShortAxisVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* [z vel,rx vel,ry vel,rz vel] meters/second for Z position, radians for rotations*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2851;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_6DMotionVelocity_Comp (*Move single xbot in 6 degrees of freedom (user set velocity)(based on previously uploaded compensation data)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		TargetPos : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* [x,y,z,rx,ry,rz] in meters for position, in radians for rotation*)
		LongAxisAccVel : {REDUND_UNREPLICABLE} ARRAY[0..1] OF REAL; (* [long axis accel,long axis vel] meters/second^2, meters/second*)
		ShortAxisVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* [z vel,rx vel,ry vel,rz vel] meters/second for Z position, radians for rotations*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2878;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ActivateTrajectory (*Command 1 - 12 xbots to follow trajectories*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots commanded to follow trajectories (up to 12)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT; (* ID#s of xbots to follow trajectories*)
		TrajID : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT; (* ID#s of the trajectories that the xbots are to follow*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have finished their trajectory(ies)*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2823;
		maxNXbots : SINT := 12;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ActivateXbots (*Activate all xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		IDMode : USINT; (* 0: full auto, 1: activate to Landed state, 2: activate to Discove mode, 3: exit Discover mode*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished activating *)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
		IDModeSent : USINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2568;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetAllStationXbots (*Gets all the xbots in all the stations*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		StateFilterCount : {REDUND_UNREPLICABLE} USINT := 1; (* number xbot states to filter for*)
		XbotStateFilters : {REDUND_UNREPLICABLE} ARRAY[0..15] OF USINT := [3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]; (* xbot states to filter for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumBays : {REDUND_UNREPLICABLE} UINT; (* Total number of bays in the system*)
		StationIDs : {REDUND_UNREPLICABLE} ARRAY[0..4999] OF USINT; (* IDs of the station*)
		BayIDs : {REDUND_UNREPLICABLE} ARRAY[0..4999] OF USINT; (* IDs of the bay*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..4999] OF USINT; (* IDs of the xbot*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBaysToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3121;
		maxNBayPerFrame : SINT := 13;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetBayXbotID (*gets the ID of the xbot in a station's bay*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		StationID : {REDUND_UNREPLICABLE} USINT; (* Station ID (>0)*)
		BayID : {REDUND_UNREPLICABLE} USINT; (* Bay ID (>0)*)
		StateFilterCount : {REDUND_UNREPLICABLE} USINT := 1; (* number xbot states to filter for*)
		XbotStateFilters : {REDUND_UNREPLICABLE} ARRAY[0..15] OF USINT := [3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]; (* xbot states to filter for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Id of the xbot in the station's bay*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3117;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetDesign (*reads an application designer file (as a raw binary) from the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		DesignID : {REDUND_UNREPLICABLE} USINT; (* design ID to read*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the read configuration file*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..499999] OF SINT; (* the application designer file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3108;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetStationXbotIDs (*Get the IDs of all xbots in a station*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		StationID : {REDUND_UNREPLICABLE} USINT; (* Station ID (>0)*)
		StateFilterCount : {REDUND_UNREPLICABLE} USINT := 1; (* number xbot states to filter for*)
		XbotStateFilters : {REDUND_UNREPLICABLE} ARRAY[0..15] OF USINT := [3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]; (* xbot states to filter for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumBays : {REDUND_UNREPLICABLE} USINT; (* number of bays in the station*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..29] OF USINT; (* IDs of the xbots in the station's bays*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3120;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetXbotTarget (*Get an xbot's target station*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID of the xbot*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		StationID : {REDUND_UNREPLICABLE} USINT; (* Station ID (>0)*)
		BayID : {REDUND_UNREPLICABLE} USINT; (* Bay ID (>0)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3119;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_HoldForBay (*Waits until a bay has an xbot ready*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		StationID : {REDUND_UNREPLICABLE} USINT; (* Station ID (>0)*)
		BayID : {REDUND_UNREPLICABLE} USINT; (* Bay ID (>0)*)
		StateFilterCount : {REDUND_UNREPLICABLE} USINT := 1; (* number xbot states to filter for*)
		XbotStateFilters : {REDUND_UNREPLICABLE} ARRAY[0..15] OF USINT := [3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]; (* xbot states to filter for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Id of the xbot in the station's bay*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		GetBayXbotID : {REDUND_UNREPLICABLE} PMC_AppDesign_GetBayXbotID;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_SaveDesign (*Sends an application designer file (as a raw binary) to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* number of bytes in the application designer file (up to 500,000 bytes) *)
		DesignID : {REDUND_UNREPLICABLE} USINT; (* design ID to save the file under *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..499999] OF SINT; (* the application designer file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3107;
		maxNByte : DINT := 500000;
		maxNBytePerFrame : SINT := 90;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_SendXbotToStation (*send an xbot to an application designer station*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : USINT;	(* the xbot to send*)
		StationID : USINT;   (* the station to send the xbot to*)
		BayID: USINT;	(* the station bay to send the xbot to*)
		WaitForFreeBay : USINT;	(* 0: xbot moves to station bay immediately, 1: xbot waits for the station bay to be free before moving*)
	END_VAR

	VAR_OUTPUT 
		Ack : BOOL := FALSE;   (* Command has been accepted by PMC*)
		Done : BOOL;   (* Xbot's motion has completed*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		requestEventID : BOOL;
		cmdHB : USINT;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 3111;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ArcMotionCenter (*Command single xbot to follow a circular arc defined by arc center and arc angle*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0:absolute;1: relative*)
		Dir : {REDUND_UNREPLICABLE} USINT; (* 0:clockwise;1:counter-clockwise*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* Velocity at the end of the motion in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* Maximum velocity for this motion in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* Maximum acceleration for this motion in meters/second^2*)
		CenterX : {REDUND_UNREPLICABLE} REAL; (* X location of the arc center in meters *)
		CenterY : {REDUND_UNREPLICABLE} REAL; (* Y location of the arc center in meters*)
		Angle : {REDUND_UNREPLICABLE} REAL; (* Arc angle in radians *)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2826;
		aDef : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ArcMotionTarget (*Command single xbots to follow a circular arc defined by target position and arc radius *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0:absolute;1: relative*)
		AType : {REDUND_UNREPLICABLE} USINT; (* 0: Minor Arc;1: Major Arc*)
		Dir : {REDUND_UNREPLICABLE} USINT; (* 0:clockwise;1:counter-clockwise*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* Velocity at the end of the motion in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* Maximum velocity for this motion in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* Maximum acceleration for this motion in meters/second^2*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X target position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y target position in meters*)
		Radius : {REDUND_UNREPLICABLE} REAL; (* Arc radius in meters*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2826;
		aDef : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoDrivingMotion (* Command multiple xbots (1-78) to target positions. Pathing is determined by PMC.*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to move (up to 78)*)
		RoutingType : USINT; (* labelled (0) or unlabelled (1) routing *)
		ZoneID : USINT; (* 0: system routing; >0: zone based routing (zone must be fenced)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* ID#s of xbots to move*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target X positions (m)*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target Y positions (m)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2836;
		maxNXbot : SINT := 78;
		maxNXbotPerFrame : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoDrivingMotionVelocity (* Command multiple xbots (1-78) to target positions (user set velocity and acceleration). Pathing is determined by PMC.*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to move (up to 78)	*)
		RoutingType : USINT; (* labelled (0) or unlabelled (1) routing *)
		ZoneID : USINT; (* 0: system routing; >0: zone based routing (zone must be fenced)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* ID#s of xbots to move*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target X positions (m)*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target Y positions (m)*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* Maximum velocity of the xbots during the command (m/s)*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* Maximum acceleration of the xbots during the command (m/s^2)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2856;
		maxNXbot : SINT := 78;
		maxNXbotPerFrame : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Activate (*activates an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for creation/activation/deactivation; >=0 with delete zone(s)*)
		NextXbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID to be assigned to next received xbot: 0-PMC assigned, >=1-user assigned *)
		NextXbotOrientation : USINT; (* Orientation assigned to next received xbot (only user assigned ID)(0-0 deg;1-90 deg;2-180 deg;3-270 deg)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 2; (* 2: activate zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Create (*Creates a new autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for creation*)
		ZoneMode : {REDUND_UNREPLICABLE} USINT; (* 0: unloading zone, 1: loading zone*)
		UnloadingMode : {REDUND_UNREPLICABLE} USINT; (* 0: soft-landing mode, 1: hard-landing mode*)
		LoadingDirection : USINT;	(* 0: auto, 1: loading from +X, 2: loading from -X, 3: loading from +Y, 4: loading from -Y *)
		LoadFailResetMode : {REDUND_UNREPLICABLE} USINT; (* 0: auto reset loading zone, 1: manual reset loading zone*)
		ZoneCenterX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of zone center at flyway boundary (m)*)
		ZoneCenterY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of zone center at flyway boundary (m)*)
		ZoneLength : {REDUND_UNREPLICABLE} REAL; (* zone length in loading/unloading direction (m)*)
		ZoneWidth : {REDUND_UNREPLICABLE} REAL; (* zone width (m)*)
		MaxXbotSizeX : {REDUND_UNREPLICABLE} REAL; (* max mover size in X (m)*)
		MaxXbotSizeY : {REDUND_UNREPLICABLE} REAL; (* max mover size in Y (m)*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* max travilling speed inside the zone (m/s)*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* max travelling acceleration inside the zone (m/s^s)*)
		MaxHeight : {REDUND_UNREPLICABLE} REAL; (* max detection height (m) (0 = no limit)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 0; (* 0: create zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Deactivate (*Deactivate an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for deactivation*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 3; (* 3: deactivate zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Delete (*deletes one or all autoloading zone(s)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: 0 - delete all zone, >0 - delete single zone *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 1; (* 1: delete zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_GetAllStatus (*Gets abbreviated status of all autoloading zones*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nZones : {REDUND_UNREPLICABLE} USINT; (* Number of autoloading zones*)
		ZoneIDs : {REDUND_UNREPLICABLE} ARRAY[0..39] OF USINT; (* The IDs of the autoloading zones*)
		ZoneStates : {REDUND_UNREPLICABLE} ARRAY[0..39] OF USINT; (* 0: undefined, 1: defined, 2: unloading zone, 3: loading zone*)
		EntranceExitStates : {REDUND_UNREPLICABLE} ARRAY[0..39] OF USINT; (* 0: busy, 1: ready (if loading zone ready = xbot ready to fetch,if unloading zone ready = zone ready to receive new xbot)*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..39] OF USINT; (* xbot ID added to unloading zone or ready to fetch from loading zone *)
		LoadingErrorCode : {REDUND_UNREPLICABLE} ARRAY[0..39] OF USINT; (* zone error code*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalZoneNum : {REDUND_UNREPLICABLE} USINT;
		index : {REDUND_UNREPLICABLE} DINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numZonesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3082;
		maxNZonePerFrame : SINT := 6;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_GetStatus (*Get status of an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		ZoneState : {REDUND_UNREPLICABLE} USINT; (* 0: undefined, 1: defined, 2: unloading zone, 3: loading zone*)
		EntranceExitState : {REDUND_UNREPLICABLE} USINT; (*0: busy, 1: ready (if loading zone ready = xbot ready to fetch,if unloading zone ready = zone ready to receive new xbot)*)
		numXbots : {REDUND_UNREPLICABLE} USINT; (* # of xbots in the zone*)
		xbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID added to unloading zone or ready to fetch from loading zone *)
		ZoneX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of entrance or exit (m)*)
		ZoneY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entrance or exit (m) *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3081;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_UnloadXbot (*Sends an xbot to an auto loading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that xbot will be sent to*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID of xbot to send to zone*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3079;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZon_HoldZoneReady (*Waits until the zone is ready (returns immediantly if zone is not activated)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		ZoneState : {REDUND_UNREPLICABLE} USINT; (* 0: undefined, 1: defined, 2: unloading zone, 3: loading zone*)
		EntranceExitState : {REDUND_UNREPLICABLE} USINT; (*0: busy, 1: ready (if loading zone ready = xbot ready to fetch,if unloading zone ready = zone ready to receive new xbot)*)
		numXbots : {REDUND_UNREPLICABLE} USINT; (* # of xbots in the zone*)
		xbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID added to unloading zone or ready to fetch from loading zone *)
		ZoneX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of entrance or exit (m)*)
		ZoneY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entrance or exit (m) *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		PMC_GetZoneStatus_db : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_GetStatus;
		xbot_is_in_zone_or_error : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadZone_LoadZoneClear (*Release an autoloading zone exit*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
		NextXbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID to be assigned to next received xbot: 0-PMC assigned, >=1-user assigned*)
		NextXbotOrientation : USINT; (* Orientation assigned to next received xbot (only user assigned ID)(0-0 deg;1-90 deg;2-180 deg;3-270 deg)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3080;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoRefresh (*Background work for PMC communication, should be called once and only once per PLC cycle*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : BOOL; (* Enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : BOOL; (* Function block executed successfully*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		FrmCount : USINT;
		curXID : INT;
		EventID1 : UINT;
		EventID2 : UINT;
		EventAck : SINT;
		nextTicketIndex : USINT;
		tempCounter : INT;
		XbotStateFrame : USINT;
		XbotStateFrameNum : USINT;
		Frame_Num : SINT := 0;
		Num_xbots_per_frame : SINT;
		stream_index : USINT;
		Num_axis_enabled : SINT;
		stream_offset : USINT;
		X_enabled : BOOL;
		Y_enabled : BOOL;
		Z_enabled : BOOL;
		Rx_enabled : BOOL;
		Ry_enabled : BOOL;
		Rz_enabled : BOOL;
		VersionNum : UDINT;
		P2H_FrmCount1 : USINT;
		P2H_FrmCount2 : USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_BlockXbotGroup (*Block the motion buffers of the xbots in a group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: block all groups; >0: block specific group*)
		IsBlock : {REDUND_UNREPLICABLE} BOOL; (* False: unblock the group(s); True: block the group(s)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		Level : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_BondXbotGroup (*Bond xbots in a group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: bond all groups; >0: bond specific group*)
		IsBond : {REDUND_UNREPLICABLE} BOOL; (* False: unbond group(s); True: bond group(s) *)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: decouple mode;1: couple mode*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		Level : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CamModeCtrl (*Slave the axes of a slave xbot to the axes of one or more master xbots via cams*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:Exit from cam mode;1: Enter cam mode*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 7)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2834;
		maxNAxis : SINT := 7;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CamModeCtrlAdvanced (*Slave the axes of a slave xbot to the axes of one or more master xbots via cams with more advanced options*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:Exit from cam mode;1: Enter cam mode*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 4)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		MasterAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis offsets (m)*)
		SlaveAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis offsets (m)*)
		MasterAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis scaling, positive only *)
		SlaveAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis scaling, positive only *)
		CamMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* cam mode; 0: auto start, 1: cyclic, 2: start once *)
		MasterOffsetMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: absolute, 1: relative*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		MasterDirection : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: master can move in bi-direction; 1: master can only move forward; 2: master can only move backward*)
		cmdHB : {REDUND_UNREPLICABLE} INT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		ModeByte : {REDUND_UNREPLICABLE} USINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2855;
		maxNAxis : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CamModeCtrlBufferable (*Slave the axes of a slave xbot to the axes of one or more master xbots via cams*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0: Begin IN End OUT, 1: End IN Begin OUT, 2: Begin IN Begin OUT, 3: End IN End OUT*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 4)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		MasterAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis scaling, positive only *)
		SlaveAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis scaling, positive only *)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
	END_VAR
	VAR CONSTANT
		dummy_zero : SINT := 0;
		cmdID : UINT := 2882;
		maxNAxis : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ClearMacro (*clear commands stored in a macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* ID# of the macro to be cleared. Macro IDs are 128 - 191*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION PMC_CmdProcessor : BOOL (*internal function used by other PMC function blocks, end user should NEVER call this themselves*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ExecutionLocation : USINT; (* 0: beginning of function block call, 1: end of function block call, 2: timeout*)
		EventCommand : BOOL; (* command supports events*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* Tracks state of the entire PMC system*)
		PMCFuncInfo : PMCFuncInfoType; (* Tracks state of a single PMC function block instance *)
		Ack : BOOL; (* PMC has received the command*)
		Done : BOOL; (* PMC has finished executing the command*)
		Busy : BOOL; (* Function block is active and must continue to be called.*)
		Error : BOOL; (* Command aborted by another command*)
		ErrorID : UINT; (* Error occurred during execution.*)
		Aborted : BOOL; (* Error number*)
	END_VAR
	VAR
		TicketCompleted : BOOL;
		CmdCounterFromPMC : USINT;
		CmdCounterToPMC : USINT;
		CmdID : UINT;
		CmdIDRtn : UINT;
		nextTicketIndex : USINT;
		tempCounter : INT;
		loopcounter : UDINT;
		EventIDFound : BOOL;
		TicketFound : BOOL;
		FrmCount1 : USINT;
		FrmCount2 : USINT;
		VersionNum : UDINT;
	END_VAR
END_FUNCTION

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2Cam (*Configure a PMC digital input to start advanced cam motion (rising edge starts cam; falling edge stops cam)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		DiID : {REDUND_UNREPLICABLE} USINT; (* digital input ID(1-128)*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 4)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		MasterAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis offsets (m)*)
		SlaveAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis offsets (m)*)
		MasterAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis scaling, positive only *)
		SlaveAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis scaling, positive only *)
		CamMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* cam mode; 0: auto start, 1: cyclic, 2: start once *)
		MasterOffsetMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: absolute, 1: relative*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		MasterDirection : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: master can move in bi-direction; 1: master can only move forward; 2: master can only move backward*)
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		ModeByte : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2881;
		maxNAxis : SINT := 4;
		commandType : USINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2QuickStop (*Configure PMC digital inputs to quickstop the PMC or a sector*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
		SectorID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of sector ID#s quick stop (0 = entire PMC)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 3;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2Reset (*Configure PMC digital inputs to reset PMC digital outputs *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
		RstDoID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital output ID#s to reset*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2RunMacro (*Configure PMC digital inputs to trigger xbots to run macros*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
		MacroID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of macro ID#s to run. Macro IDs are 128 - 191*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of ID#s to run the macros *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 2;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2Trigger (*Configure PMC digital inputs to act as macro triggers *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* Number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2CmdLb (*Configure digital outputs to set on command labels*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for the command labels *)
		CmdLb : {REDUND_UNREPLICABLE} ARRAY[0..4] OF UINT; (* array of command labels to set on*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* when to set the digital output 0: Cmd Label Start; 1: Cmd Label End; 2: Cmd Label state*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Disp (*Configure digital outputs to set on xbot displacements*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for displacement*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Positive Cross; 1: Negative Cross; 2: State*)
		Mode : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: X only; 1: Y only ; 2: XFactor*X + YFactor*Y*)
		Threshold : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* Thresholds for output trigger in meters*)
		XFactor : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* XFactor used for Mode #2*)
		YFactor : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* YFactor used for Mode #2*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Force (*Configure digital outputs to set on xbot force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for force*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Positive Cross; 1: Negative Cross; 2: State*)
		AxisID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 1: X axis; 2: Y axis; 3: Z axis; 4: Rx; 5: Ry; 6: Rz;*)
		Threshold : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* Thresholds for output trigger in Newtons/Newton*Meters*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Motion (*Configure digital outputs to set on xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for motion*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Motion Start; 1: Motion End; 2: Motion state*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Zone (*Configure digital outputs to set on number of xbots in a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		ZoneID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of Zone ID#s to monitor for number of movers in the zone*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: mover count rising about threshold; 1: mover count falling below threshold; 2: mover count higher than threshold  *)
		Threshold : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* Thresholds for output trigger in number of movers  *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigFBStream (*Configure feedback streams for xbots position or force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nStm : {REDUND_UNREPLICABLE} USINT; (* number of feedback streams (up to 8)*)
		StmID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (* feedback stream ID*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (* xbot ID# for the stream*)
		FBMode : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (*	0: position; 1: force; 2: reference position; 3: tracking error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		stmNum : {REDUND_UNREPLICABLE} USINT;
		Index : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2828;
		maxNStm : SINT := 8;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigFBStreamExtended (*Configure extended feedback streams for xbots position or force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of feedback streams (up to 150)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* xbot ID# for the stream*)
		FBMode : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* 0: position; 1: force; 2: reference position; 3: tracking error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} USINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2866;
		maxNXbot : USINT := 150;
		maxNXbotPerFrame : SINT := 44;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Config_GetConfiguration (*Read the configuration file (as raw binary) from the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the read configuration file*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..499999] OF SINT; (* the configuration file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65293;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Config_SetConfiguration (*Sends a configuration file (as raw binary) to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* number of bytes in the configuration file (up to 500,000 bytes) *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..499999] OF SINT; (* the configuration file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65292;
		maxNByte : DINT := 500000;
		maxNBytePerFrame : SINT := 90;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ControllerReset (*Resets PMCControllerType internal state, DO NOT ACTIVATE WHEN PMC IS RUNNING*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (*Reset starts on rising edge of this input*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (*Reset complete*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*PMC variable to reset*)
	END_VAR
	VAR
		NumCycles : {REDUND_UNREPLICABLE} USINT := 0;
		i : {REDUND_UNREPLICABLE} DINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CreateXbotGroup (*Create a xbot group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* must be greater than 0*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to be in the group (up to 32)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* xbot ID#s to be in the group*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		maxNXbot : SINT := 32;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_DeactivateXbots (*Deactivate all xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished deactivating*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2570;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_DeleteTrajectory (*Delete trajectory file*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		TrajID : {REDUND_UNREPLICABLE} USINT; (* 0: delete all trajectory files; >0: delete specific trajectory file*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65294;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_DeleteXbotGroup (*delete a xbot group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: delete all groups; >0: delete specific group*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_FindXbotsInArea (*Find all xbots whose centers are within a rectangular area*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* Enable function block*)
		BottomLeftX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of bottom left corner of area (m)*)
		BottomLeftY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of bottom left corner of area (m)*)
		TopRightX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of top right corner of area (m)*)
		TopRightY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of top right corner of area (m)	*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* 1 if values are valid*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number of xbots whose centers are in the area*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* IDs of xbots whose centers are in the area*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ReadXbotPos : {REDUND_UNREPLICABLE} PMC_ReadXbotPos;
		ReadXbotIDs : {REDUND_UNREPLICABLE} PMC_ReadXbotIDs;
		AllXbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		AllXbotIndex : {REDUND_UNREPLICABLE} USINT;
		InZoneIndex : {REDUND_UNREPLICABLE} USINT;
		Tolerance : {REDUND_UNREPLICABLE} REAL := 1.0E-4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ForceModeCtrl (*activate force mode control on a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Mode : USINT; (* 0: absolte force mode; 1:relative force mode*)
		Level : USINT; (* 0: Exit from force mode;1: Z force mode;2: X force mode;3: Y force mode;4: XY force mode;5: Z torque mode;8: X force + Z torque;9: Y force + Z torque;11: X force + Y force + Z torque*)
		Buffer : USINT; (* 0: enter/exit force mode immediately; 1:add mode change to motion buffer*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# of the xbot to activate force mode control*)
		ForceX : {REDUND_UNREPLICABLE} REAL; (* force in X in Newtons*)
		ForceY : {REDUND_UNREPLICABLE} REAL; (* force in Y in Newtons*)
		ForceZ : {REDUND_UNREPLICABLE} REAL; (* force in Z in Newtons*)
		TorqueZ : REAL; (* torque around the Z axis in Newton Meters*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2833;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ForceModeCtrlEx (*activate force mode control on a xbot with extended options*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: absolute force mode; 1:relative force mode*)
		Level : {REDUND_UNREPLICABLE} USINT; (* Set which axises have force mode (0-position,1-force): bit0-Fx, bit1-Fy, bit2-Fz, bit3-Tx, bit4-Ty, bit5-Tz *)
		Buffer : {REDUND_UNREPLICABLE} USINT; (* 0: enter/exit force mode immediately; 1:add mode change to motion buffer*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# of the xbot to activate force mode control*)
		ForceX : {REDUND_UNREPLICABLE} REAL; (* force in X in Newtons*)
		ForceY : {REDUND_UNREPLICABLE} REAL; (* force in Y in Newtons*)
		ForceZ : {REDUND_UNREPLICABLE} REAL; (* force in Z in Newtons*)
		TorqueX : {REDUND_UNREPLICABLE} REAL; (* torque around the X axis in Newton Meters*)
		TorqueY : {REDUND_UNREPLICABLE} REAL; (* torque around the Y axis in Newton Meters*)
		TorqueZ : {REDUND_UNREPLICABLE} REAL; (* torque around the Z axis in Newton Meters*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2880;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GCode_DeleteGCode (*Delete G-code file*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GCodeID : {REDUND_UNREPLICABLE} USINT; (* 0: delete all G-code files; >0: delete specific G-code file*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65298;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GCode_GetGCodeIDs (*Get the IDs of all G-code files on the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nIDs : {REDUND_UNREPLICABLE} USINT; (* Number of G-code files on the PMC*)
		GCodeIDs : {REDUND_UNREPLICABLE} ARRAY[0..63] OF USINT; (* the IDs of the G-code files on the PMC*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} SINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65300;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GCode_ReadGCode (*Reads a G-code file from the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GCodeID : {REDUND_UNREPLICABLE} USINT; (* GCode ID# (1-64)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the read G-code file	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
		Bytes : ARRAY[0..199999] OF SINT; (* the G-code as a raw binary*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65299;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GCode_RunGCode (*Run G-code file*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		GCodeID : {REDUND_UNREPLICABLE} USINT; (* G-code ID# (1-64)*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots has finished the macro*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2861;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GCode_SaveGCode (*Send a G-code file to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GCodeID : {REDUND_UNREPLICABLE} USINT; (* GCode ID# (1-64)*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* number of bytes in the G-code file (up to 200,000 bytes)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
		Bytes : ARRAY[0..199999] OF SINT; (* the G-code file as a raw binary*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65298;
		maxNByte : DINT := 200000;
		maxNBytePerFrame : SINT := 90;
		mode : SINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetAllAccidentXbots (*Get the number and IDs of all accident xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number of accident xbots*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* The IDs of the accident xbots*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} DINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2863;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetBorderStatus (*Get the status of a border*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		BorderID : {REDUND_UNREPLICABLE} USINT; (* Border ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* Border Status: 0 - disconnected, 1 - connected, but not ready, 2 - ready*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2603;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetBufferStatus (*Get status of a Xbot's motion buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* Buffer state; 0: unblocked; 1: blocked *)
		nCmds : {REDUND_UNREPLICABLE} UINT; (* number of commands in the buffer*)
		nextCmdLb : {REDUND_UNREPLICABLE} UINT; (* Command label of first command in the buffer*)
		newCmdLb : {REDUND_UNREPLICABLE} UINT; (* Command label of last command in the buffer*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2837;
		level : USINT := 3;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetErrorLog (*Read the PMC's error log*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the error log file*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
		Bytes : ARRAY[0..99999] OF SINT; (* the error log file as a raw binary*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65282;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetFlywayError (*Get flyway error code*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlywayID : {REDUND_UNREPLICABLE} USINT; (* Flyway ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		FlywayErrorCode : {REDUND_UNREPLICABLE} UDINT; (* The read error code (0 = no error)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2586;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetFlywaySerialNum (*Reads the serial number of a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlywayID : {REDUND_UNREPLICABLE} USINT; (* Flyway logical ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		SerialNumHigh : {REDUND_UNREPLICABLE} UDINT; (* High 32 bits of serial number (left 4 bytes)*)
		SerialNumLow : {REDUND_UNREPLICABLE} UDINT; (* Low 32 bits of serial number (right 4 bytes)*)
		FirmwareVersion : {REDUND_UNREPLICABLE} UDINT; (* Flyway firmware version number*)
		AppDataVersion : {REDUND_UNREPLICABLE} UDINT; (* Flyway application data version*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2588;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetFlywayTemp (*Get temperatures and power consumption of a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlwID : {REDUND_UNREPLICABLE} USINT; (* Flyway ID*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Power : {REDUND_UNREPLICABLE} REAL; (* Flyway power consumption in watts*)
		CPUTemp : {REDUND_UNREPLICABLE} REAL; (* Flyway CPU temperature in degrees Celsius (integer precision)*)
		PATemp : {REDUND_UNREPLICABLE} REAL; (* Power amplifier temperature in degrees Celsius (integer precision)*)
		MTemp : {REDUND_UNREPLICABLE} REAL; (* Motor temperature in degrees Celsius (integer precision)*)
		CPUTempFloat : {REDUND_UNREPLICABLE} REAL; (* Flyway CPU temperature in degrees Celsius (floating point precision)*)
		PATempFloat : {REDUND_UNREPLICABLE} REAL; (* Power amplifier temperature in degrees Celsius (floating point precision)*)
		MTempFloat : {REDUND_UNREPLICABLE} REAL; (* Motor temperature in degrees Celsius (floating point precision)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		intTemp : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2582;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetGroupStatus (*Get status of a xbot group *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* Group ID > 0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: unbonded 1:bonded*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in the group*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* xbot ID#s of the xbots in the group*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		maxNXbot : SINT := 32;
		Level : USINT := 6;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetIncomingXbots (*Get the number of and IDs of any incoming xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number of incoming xbots*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* The IDs of the incoming xbots*)
		BorderIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* The IDs of the borders that the xbots are crossing*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalXbotNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} DINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numXbotsToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2604;
		maxNXbotPerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetMacroStatus (*get status of a macro *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* Macro ID#*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: unsaved, 1: reserved, 2: saved*)
		nCmds : {REDUND_UNREPLICABLE} USINT; (* number of commands in the macro*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPayload (*Get payload of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Payload : {REDUND_UNREPLICABLE} REAL; (* xbot payload in kilograms*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2848;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMCErrorCode (*Retreive the latest PMC error codes*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumErrors : {REDUND_UNREPLICABLE} USINT; (* Number of error codes read *)
		ErrorCodes : {REDUND_UNREPLICABLE} ARRAY[0..8] OF DINT; (* The read error codes*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		eIndex : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2573;
		maxErrors : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMCSerialNum (*Reads the serial number of the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		SerialNumHigh : {REDUND_UNREPLICABLE} UDINT; (* High 32 bits of serial number (left 4 bytes)*)
		SerialNumLow : {REDUND_UNREPLICABLE} UDINT; (* Low 32 bits of serial number (right 4 bytes)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2587;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPmcStatus (*Get status of the Planar Motor Controller  *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
		nXbots : {REDUND_UNREPLICABLE} UINT; (* number of XBots*)
		Power : {REDUND_UNREPLICABLE} REAL; (* system power consumption in Watts*)
		MaxCPUTemp : {REDUND_UNREPLICABLE} REAL; (* highest cpu temperature in the system in degrees Celsius (integer precision)*)
		MaxPATemp : {REDUND_UNREPLICABLE} REAL; (* highest amplifier temperature in the system in degrees Celsius (integer precision)*)
		MaxMTemp : {REDUND_UNREPLICABLE} REAL; (* highest motor temperature in the system in degrees Celsius (integer precision)*)
		FieldbusStatus : {REDUND_UNREPLICABLE} USINT; (*0: connected and synced; 1: disconnected; 2: connected but not synced*)
		PMNetStatus : {REDUND_UNREPLICABLE} USINT; (*0: connected; 1: disconnected*)
		MoverIDScanStatus : {REDUND_UNREPLICABLE} USINT; (*0: at least one xbot doesn't finish XID scan; 1: all xbots finished XID scan*)
		PMCErrorCode : {REDUND_UNREPLICABLE} UDINT; (*current PMC error code (0 is OK)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		mTemp : {REDUND_UNREPLICABLE} BYTE;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2565;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMCVersion (*Gets the PMC software version number*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		VersionNumHigh : {REDUND_UNREPLICABLE} UDINT; (* High 32 bits of version number (left 4 bytes)*)
		VersionNumLow : {REDUND_UNREPLICABLE} UDINT; (* Low 32 bits of version number (right 4 bytes)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2572;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMCWarnings (*Get the last 100 warning codes from the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nWarnings : {REDUND_UNREPLICABLE} USINT; (* Number of warnings*)
		Warnings : {REDUND_UNREPLICABLE} ARRAY[0..99] OF UDINT; (* the warning codes*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2585;
		maxNBytePerFrame : SINT := 10;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetSpacedXbotPositions (*Get spaced out xbot positions*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number xbots in system*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* The IDs of the xbots in the system*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..149] OF REAL; (* Spaced out X positions*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..149] OF REAL; (* Spaced out Y positions*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} DINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numXbotsToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3858;
		maxNXbotPerFrame : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetWarningLog (*Read the PMC's warning log*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the warning log file*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
		Bytes : ARRAY[0..99999] OF SINT; (* the warning log file as a raw binary*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65286;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetXbotIDs (*Gets the number of xbots in system and their ID#s (up to 99 xbots)(much slower than ReadXbotIDs)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot state*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in system*)
		Xbot_IDs : {REDUND_UNREPLICABLE} ARRAY[0..98] OF USINT; (* xbot ID#s of xbots in the system*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		xbot_array_index : {REDUND_UNREPLICABLE} USINT;
		XbotID : {REDUND_UNREPLICABLE} USINT;
		GetXbotStatus : {REDUND_UNREPLICABLE} PMC_GetXbotStatus;
		ReadXbotState : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		internal_num_xbots : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetXbotProperty (*Get properties of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		MoverType : {REDUND_UNREPLICABLE} USINT; (* xbot type (0 = M3-06,2 = M3-08,4 = M3-09X,5 = M3-09Y,6 = M3-10,8 = M3-11X,9 = M3-11Y,12 = M3-12,14 = M3-13)*)
		PayloadW : {REDUND_UNREPLICABLE} REAL; (* payload weight in kilograms*)
		PayloadCG : {REDUND_UNREPLICABLE} REAL; (* payload center of gravity in meters*)
		XDim : {REDUND_UNREPLICABLE} REAL; (* mover X dimension in meters*)
		YDim : {REDUND_UNREPLICABLE} REAL; (* mover Y dimension in meters*)
		accLimit : {REDUND_UNREPLICABLE} REAL; (* acceleration limit in meters/second^2*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2846;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetXbotStatus (*Get status of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		FeedbackType : {REDUND_UNREPLICABLE} USINT; (* 0: Feedback Position 1: Feedback Force*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* xbot state; 0: undetected; 1: discovering; 2: landed; 3: idling; 4: disabled; 5: motion; 6: waiting; 7: stopping; 8: obstacle; 9: hold; 10: stopped; 14: error;*)
		CmdLb : {REDUND_UNREPLICABLE} UINT; (* Command Label@Motion State*)
		FMState : {REDUND_UNREPLICABLE} USINT; (* 0: Not Force Mode;1: X force mode;2: Y force mode;4: Z force mode;3: XY force mode*)
		StarXID : {REDUND_UNREPLICABLE} USINT; (* 0: Not linked to any xbot; >0: start Xbot ID*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: Not bond to any group; >0: group ID*)
		nCmds : {REDUND_UNREPLICABLE} UINT; (* number of commands in motion buffer*)
		IsBlocked : {REDUND_UNREPLICABLE} BOOL; (* is the xbot buffer blocked*)
		IsPaused : {REDUND_UNREPLICABLE} BOOL; (* is the xbot motion paused*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* xbot X position in meters, force in Newtons*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* xbot Y position in meters, force in Newtons*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* xbot Z position in meters, force in Newtons*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the X axis in radians, torque in Newton*Meters *)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the Y axis in radians, torque in Newton*Meters*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the Z axis in radians, torque in Newton*Meters*)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (* XBot stereotype ID*)
		MoverType : {REDUND_UNREPLICABLE} USINT; (* XBot Type (0 = M3-06,2 = M3-08,4 = M3-09X,5 = M3-09Y,6 = M3-10,8 = M3-11X,9 = M3-11Y,12 = M3-12,14 = M3-13)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		bTemp : {REDUND_UNREPLICABLE} BYTE;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2831;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForPMCState (*Waits until PMC reaches a given state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		State : {REDUND_UNREPLICABLE} USINT; (* PMC state to wait for 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the PMC reached the state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for PMC state*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error has occured*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ReadPMCState_db : {REDUND_UNREPLICABLE} PMC_ReadPmcState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotIdle (*Waits until the xbot is in idle state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (*xbot to wait for (1-78)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotsIdle (*Waits until all chosen xbots are in idle state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to wait for (1-78)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbots to wait for (1-78)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		scan_all_xbots : {REDUND_UNREPLICABLE} BOOL;
		all_xbots_reached_state : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotsState (*Waits until all chosen xbots are in given states*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to wait for (1-78)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbots to wait for (1-78)*)
		States : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* states to wait for 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		scan_all_xbots : {REDUND_UNREPLICABLE} BOOL;
		all_xbots_reached_state : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotState (*Waits until the xbot are in the given state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (*xbot to wait for (1-78)*)
		State : {REDUND_UNREPLICABLE} USINT; (* state to wait for 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the state state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_InjectNoise (*inject sinusoidal force/torque signals to one or multiple axes of xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: turn off noise,1: turn on noise*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot to inject noise (>0)*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (* number of axises to inject noise into*)
		AxisIDs : {REDUND_UNREPLICABLE} ARRAY[0..5] OF USINT; (* axis IDs to inject noise into (1-X; 2-Y; 3-Z; 4-Rx; 5-Ry; 6-Rz)*)
		Amplitudes : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* amplitudes of sinusoidal signals (N or Nm)*)
		Frequencies : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* frequencies of sinusoidal signals (Hz,maximum is 655 Hz,precision of 0.01 Hz)*)
		Phases : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* phases of sinusoidal signals (degrees,precision of 0.01 degs)*)
		Durations : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* durations of sinusoidal signals (s)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Noise has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		Index : {REDUND_UNREPLICABLE} DINT;
		FrequencyUint : {REDUND_UNREPLICABLE} UINT;
		PhaseUint : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		dummy_zero : SINT := 0;
		cmdID : UINT := 2857;
		maxNAxis : USINT := 6;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_InjectNoiseDelay (*inject sinusoidal force/torque signals with delays to one or multiple axes of xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: turn off noise,1: turn on noise*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot to inject noise (>0)*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (* number of axises to inject noise into*)
		AxisIDs : {REDUND_UNREPLICABLE} ARRAY[0..5] OF USINT; (* axis IDs to inject noise into (1-X; 2-Y; 3-Z; 4-Rx; 5-Ry; 6-Rz)*)
		Amplitudes : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* amplitudes of sinusoidal signals (N or Nm)*)
		Frequencies : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* frequencies of sinusoidal signals (Hz,maximum is 655 Hz,precision of 0.01 Hz)*)
		Phases : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* phases of sinusoidal signals (degrees,precision of 0.01 degs)*)
		Durations : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* durations of sinusoidal signals (s)*)
		Delays : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* delays of sinusoidal signals (s,maximum is 655 sec,precision of 0.01 sec)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Noise has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		Index : {REDUND_UNREPLICABLE} DINT;
		FrequencyUint : {REDUND_UNREPLICABLE} UINT;
		PhaseUint : {REDUND_UNREPLICABLE} UINT;
		DelayUint : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		dummy_zero : SINT := 0;
		cmdID : UINT := 2883;
		maxNAxis : USINT := 6;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_JogShortAxis (*jog a xbot in short axises (Z, Rx, Ry, or Rz)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		Enable : {REDUND_UNREPLICABLE} BOOL; (* 0: stop jogging xbot; 1: start jogging xbot*)
		AxisID : {REDUND_UNREPLICABLE} USINT; (* Axis to jog; 0-Z, 1-Rx, 2-Ry, 3-Rz*)
		Velocity : {REDUND_UNREPLICABLE} REAL; (* jogging speed in meters/second or radians/second*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		AxisMode : {REDUND_UNREPLICABLE} USINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2842;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_JogVelocity (*jog a xbot in x/y plane*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		Enable : {REDUND_UNREPLICABLE} BOOL; (* 0: stop jogging xbot; 1: start jogging xbot*)
		Direction : {REDUND_UNREPLICABLE} REAL; (* direction to jog in radians*)
		Velocity : {REDUND_UNREPLICABLE} REAL; (* jogging speed in meters/second*)
		Acceleration : {REDUND_UNREPLICABLE} REAL; (* Jogging acceleration in meters/second^2 (if <0.15 m/s^2 max acceleration is used)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2842;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_LevitationCtrl (*Levitate/Land a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: leviate/land all xbots; >0: leviate/land specific xbot*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0 = landed, 1 = levitate*)
		Speed : USINT; (* 0 = 1.6s, 1= 0.8s, 2 = 0.4s, 3 = 0.2s, 4 = 0.1s, 5 = 0.05s (all times approximate)*)
		LandedZForce : REAL; (* Z axis force when the xbot is landed (Newtons)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have finished leviating/landing*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2829;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_LevitationCtrlSpeed (*Levitate/Land a xbot with control over the speed of the landing/levitation*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: leviate/land all xbots; >0: leviate/land specific xbot*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0 = landed, 1 = levitate*)
		Speed : {REDUND_UNREPLICABLE} USINT; (* 0 = 1.6s, 1= 0.8s, 2 = 0.4s, 3 = 0.2s, 4 = 0.1s, 5 = 0.05s (all times approximate) *)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have finished leviating/landing*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2829;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_LinkedMover_Assign (*Assigns the linkage defined to xbots, and starts up the CAM and sun-planet relationship if possible*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.			*)
		LinkID : {REDUND_UNREPLICABLE} USINT; (*ID of the linkage [1, 64]*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (*Xbot IDs of the slaves*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		LinkedXbotID : {REDUND_UNREPLICABLE} USINT; (* linked xbot ID, used to drive the linked xbots*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3852;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_LinkedMover_CamSlaves (*Define masked axis of mover linkage, where multiple movers' motion is combined via a CAM (linked cams only respond to single axis motion) to actuate an mechanical axis*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.			*)
		LinkID : {REDUND_UNREPLICABLE} USINT; (*ID of the linkage [1, 64]*)
		MasterAxis : {REDUND_UNREPLICABLE} USINT; (*master axis: 1-X,2-Y,3-Z,4-Rx,5-Ry,6-Rz*)
		MasterAxisOffset : {REDUND_UNREPLICABLE} REAL; (*master axis offset to linkage center(m)*)
		NumSlaveAxes : {REDUND_UNREPLICABLE} USINT; (*number of slave axis (1-8);*)
		SlaveID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (*which of the 4 slave xbots to be cammed*)
		SlaveAxis : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (*slave axes: 1-X,2-Y,3-Z,4-Rx,5-Ry,6-Rz*)
		SlaveCamID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (*cams to use*)
		SlaveAxisOffset : {REDUND_UNREPLICABLE} ARRAY[0..7] OF REAL; (*slave axis offsets to link center(m)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3851;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_LinkedMover_Define (*Defines a new mover linkage*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		LinkID : {REDUND_UNREPLICABLE} USINT; (*ID of the linkage [1, 64]*)
		nSlaves : {REDUND_UNREPLICABLE} USINT; (*number of slave xbots in the linkage*)
		SlaveX : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (*Default X positions of slaves relative to linkage center(m)*)
		SlaveY : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (*Default Y positions of slaves relative to linkage center(m)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3850;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MotionBufferCtrl (*Control a xbots motion buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0: Block buffer;1: release buffer;2: clear buffer*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: control all xbot buffers; >0: control specific xbot buffer*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2837;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_AutoScan (*Start absolute ID auto scanning for the entire PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* 0-Scan using all available area in system,>0-scan using area defined by zone ID*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2623;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_ChangeAbsoluteIDs (*Change absolute IDs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to change absolute IDs (<=200)*)
		CurrentIDs : {REDUND_UNREPLICABLE} ARRAY[0..199] OF USINT; (* current absolute IDs to change*)
		NewIDs : {REDUND_UNREPLICABLE} ARRAY[0..199] OF USINT; (* new absolute IDs to change to*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalXbotNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2574;
		maxNXbot : DINT := 200;
		maxNXbotPerFrame : SINT := 44;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_ManualScan (*manually scan a single xbot for its absolute ID*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID# (>0)*)
		Orientation : {REDUND_UNREPLICABLE} USINT; (* 0-East;1-North;2-West;3-South*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has finished scanning*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2628;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_RecoverID (*recover XID after flyway error*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		Index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2637;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverStereotype_Assign (*Assign a stereotype to a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.			*)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (*ID of the mover stereotype. [1, 255]	*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (*ID of the XBot to assign to. 0 = all XBots*)
		BufferAssign : {REDUND_UNREPLICABLE} USINT; (*0: assign stereotype immediately; 1:add stereotype change to motion buffer*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2854;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverStereotype_Define (*Define a mover stereotype*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MoverType : {REDUND_UNREPLICABLE} USINT; (*XBot Type (0 = M3-06,2 = M3-08,4 = M3-09X,5 = M3-09Y,6 = M3-10,8 = M3-11X,9 = M3-11Y,12 = M3-12,14 = M3-13) *)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (*ID of the mover stereotype. [1, 255]	*)
		PerformanceLevel : {REDUND_UNREPLICABLE} USINT; (*[0,3]. 0 is most stable, 3 is most responsive*)
		Cg : {REDUND_UNREPLICABLE} ARRAY[0..2] OF REAL; (*[x, y, z] overall center of mass loccation from the mover center, in meters.    *)
		PayloadWeight : {REDUND_UNREPLICABLE} REAL; (*weight of the payload, in kg	 *)
		PayloadSize : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (*[+x, -x, +y, -y] payload size, as measured from the mover center, in meters*)
		EmergencyStopDecel : {REDUND_UNREPLICABLE} REAL; (*Acceleration limit during emergency stop (m/s^2)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2852;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverStereotype_ReadDef (*Read a mover stereotype*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MoverType : {REDUND_UNREPLICABLE} USINT; (*XBot Type (0 = M3-06,2 = M3-08,4 = M3-09X,5 = M3-09Y,6 = M3-10,8 = M3-11X,9 = M3-11Y,12 = M3-12,14 = M3-13)*)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (*ID of the mover stereotype. [1, 255]	*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Output data is valid*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		PerformanceLevel : {REDUND_UNREPLICABLE} USINT; (*[0,3]. 0 is most stable, 3 is most responsive*)
		Cg : {REDUND_UNREPLICABLE} ARRAY[0..2] OF REAL; (*[x, y, z] overall center of mass loccation from the mover center, in meters.    *)
		PayloadWeight : {REDUND_UNREPLICABLE} REAL; (*weight of the payload, in kg	 *)
		PayloadSize : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (*[+x, -x, +y, -y] payload size, as measured from the mover center, in meters*)
		EmergencyStopDecel : {REDUND_UNREPLICABLE} REAL; (*Acceleration limit during emergency stop (m/s^2)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2853;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_OverwriteFlywayConfig (*Sends a configuration file (as raw binary) to a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlywayID : {REDUND_UNREPLICABLE} USINT; (* ID of flyway to overwrite*)
		nBytes : {REDUND_UNREPLICABLE} INT; (* number of bytes in the configuration file (up to 1,000 bytes) *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..999] OF SINT; (* the configuration file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65311;
		maxNByte : DINT := 1000;
		maxNBytePerFrame : SINT := 90;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_PauseXbots (*pause xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: all Xbots; >0: specific Xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have paused motion*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2849;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_PlanetMotionCtrl (*begin star-planet motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:disconnect from star xbot;1: connect to star xbot;2: connect to star w/ coupled RZ*)
		StarXID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# of the star xbot*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of planet xbots (up to 32)*)
		PlanetXID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* planet xbot ID#s*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2847;
		maxNXbot : SINT := 32;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadDigitalSignalFromPMC (*read status of the PMC digital outputs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* Enable function block*)
		DiID : {REDUND_UNREPLICABLE} USINT; (* digital input (of the PLC fieldbus) number [1-128]*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* function block successfully read the digital signal*)
		Level : {REDUND_UNREPLICABLE} BOOL; (* level of the digital signal*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} DINT;
		BitOffset : {REDUND_UNREPLICABLE} DINT;
		RegVal : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadNumAccidentXbots (*Read number of accident xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read number of incoming xbots*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number of incoming xbots*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadNumIncomingXbots (*read the number of xbots coming from neighbor PMCs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read number of incoming xbots*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* Number of incoming xbots*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadPmcState (*Read Planar Motor Controller state *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read PMC state*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadStreamFeedback (*read xbot stream feedback*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		StreamChannelID : {REDUND_UNREPLICABLE} USINT; (* stream channel ID#*)
		XBotAxisID : {REDUND_UNREPLICABLE} USINT; (* Axis ID. X=1, Y=2, Z=3, RX=4, RY=5, RZ=6*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot stream feedback*)
		FeedbackValue : {REDUND_UNREPLICABLE} REAL; (* value read from stream: meters/Newtons for X, Y, Z; radians/Newton*Meters for Rx, Ry, Rz*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		AxisCount : {REDUND_UNREPLICABLE} USINT;
		ByteOffset : {REDUND_UNREPLICABLE} UINT;
		tempFBAxis : {REDUND_UNREPLICABLE} USINT;
		index : {REDUND_UNREPLICABLE} SINT;
		CurrentAxisOffset : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadStreamFeedbackExtended (*read extended xbot stream feedback*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* stream channel ID#*)
		XBotAxisID : {REDUND_UNREPLICABLE} USINT; (* Axis ID. X=1, Y=2, Z=3, RX=4, RY=5, RZ=6*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot stream feedback*)
		FeedbackValue : {REDUND_UNREPLICABLE} REAL; (* value read from stream: meters/Newtons for X, Y, Z; radians/Newton*Meters for Rx, Ry, Rz*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadTimeStamp (*Read the timestamp of the PMC communication frame*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read the timestamp*)
		TimeStamp_ns : {REDUND_UNREPLICABLE} LREAL; (* timestamp value in nanoseconds (local PMC time since power on) *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		TimeStamp_High : {REDUND_UNREPLICABLE} UDINT;
		TimeStamp_Low : {REDUND_UNREPLICABLE} UDINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadTrajectoryHash (*Reads the hash (MD5) and other parameters of the trajectory *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		TrajID : {REDUND_UNREPLICABLE} USINT; (* trajectory to read*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Axises : {REDUND_UNREPLICABLE} USINT; (* what axises are in the trajectory file: bit0=X; bit1=Y; bit2=Z; bit3=Rx; bit4=Ry; bit5=Rz; bit6=DO (1 means axis selected; 0 means not selected)*)
		TimeInterval : {REDUND_UNREPLICABLE} REAL; (*time interval between positions (seconds)  *)
		TrajHash : {REDUND_UNREPLICABLE} ARRAY[0..15] OF USINT; (*MD5 hash of the traj file*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65295;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotForce (*read xbot force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-78)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot force*)
		Fx : {REDUND_UNREPLICABLE} REAL; (* force in X in Newtons*)
		Fy : {REDUND_UNREPLICABLE} REAL; (* force in Y in Newtons*)
		Fz : {REDUND_UNREPLICABLE} REAL; (* force in Z in Newtons *)
		Tx : {REDUND_UNREPLICABLE} REAL; (* torque about X axis in Newton*Meters*)
		Ty : {REDUND_UNREPLICABLE} REAL; (* torque about Y axis in Newton*Meters*)
		Tz : {REDUND_UNREPLICABLE} REAL; (* torque about Z axis in Newton*Meters*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		curXID : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotIDs (*Reads the number of xbots in system and their ID#s (up to 78 xbots)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot state*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in system*)
		Xbot_IDs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbot ID#s of xbots in the system*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		done_local : {REDUND_UNREPLICABLE} BOOL;
		xbot_array_index : {REDUND_UNREPLICABLE} DINT;
		xbot_loop_index : {REDUND_UNREPLICABLE} DINT;
		xbot_state : {REDUND_UNREPLICABLE} USINT;
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotPos (*read xbot position*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable FUNCTION block *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-127)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* xbot position is up-TO-DATE, if FALSE the output position is the last known position *)
		PosX : {REDUND_UNREPLICABLE} REAL; (* xbot X position in meters *)
		PosY : {REDUND_UNREPLICABLE} REAL; (* xbot Y position in meters *)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* xbot Z position in meters *)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about X axis in radians *)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Y axis in radians *)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Z axis in radians *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		curXID : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotSpeed (*Use feedback or extended feedback to calculate a xbot's speed (feedback or extended feedback must be configured before hand)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		FeedbackType : {REDUND_UNREPLICABLE} USINT; (* 0: using normal feedback, 1: using extended feedback*)
		ID : {REDUND_UNREPLICABLE} USINT; (* stream/xbot ID (feedback position must update two times before the output is valid)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read the xbot speed*)
		SpeedX : {REDUND_UNREPLICABLE} REAL; (* speed in the X axis in m/s*)
		SpeedY : {REDUND_UNREPLICABLE} REAL; (* speed in the Y axis in m/s*)
		SpeedRz : {REDUND_UNREPLICABLE} REAL; (* speed in the Rz axis in rad/s*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ReadFeedback : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedback;
		ReadFeedbackEx : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		ReadTimeStamp : {REDUND_UNREPLICABLE} PMC_ReadTimeStamp;
		PastX : {REDUND_UNREPLICABLE} REAL;
		PastY : {REDUND_UNREPLICABLE} REAL;
		PastRz : {REDUND_UNREPLICABLE} REAL;
		PastTime_ns : {REDUND_UNREPLICABLE} LREAL;
		PastID : {REDUND_UNREPLICABLE} USINT;
		PresentX : {REDUND_UNREPLICABLE} REAL;
		PresentY : {REDUND_UNREPLICABLE} REAL;
		PresentRz : {REDUND_UNREPLICABLE} REAL;
		PresentTime_ns : {REDUND_UNREPLICABLE} LREAL;
		PresentID : {REDUND_UNREPLICABLE} USINT;
		Frame_Num : {REDUND_UNREPLICABLE} SINT := 0;
		Num_axis_enabled : {REDUND_UNREPLICABLE} SINT;
		Num_xbots_per_frame : {REDUND_UNREPLICABLE} SINT;
		stream_index : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotState (*read a xbot's state (ID <=200)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable FUNCTION block *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-78)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot state *)
		State : {REDUND_UNREPLICABLE} USINT; (* 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} USINT;
		BitOffset : {REDUND_UNREPLICABLE} USINT;
		uTemp : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		MaxXbots : USINT := 200;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotStateEx (*read a xbot's state (any ID, but with increased latency)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID#*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* xbot state is up-to-date, if false the output state is the last known state*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		curXID : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotStatus (*read a xbot's status*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-127)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* xbot status is up-to-date, if false the output position is the last known status*)
		ControlMode : {REDUND_UNREPLICABLE} USINT; (* 0: position mode; 1: force mode*)
		MotionStatus : {REDUND_UNREPLICABLE} USINT; (* 0: resumed; 1:paused*)
		BufferStatus : {REDUND_UNREPLICABLE} USINT; (* 0: buffer released; 1:buffer blocked*)
		GroupStatus : {REDUND_UNREPLICABLE} USINT; (* 0: unbond to group; 1:bonded to group*)
		PlanetStatus : {REDUND_UNREPLICABLE} USINT; (* 0: unlinked to planet; 1: linked to planet*)
		LockStatus : {REDUND_UNREPLICABLE} USINT; (* 0: xbot free; 1: xbot locked*)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (* active stereotype ID for this xbot *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		curXID : {REDUND_UNREPLICABLE} USINT;
		StatusByte : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_Reboot (*reboot Planar Motor System*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* The PMC has finished rebooting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2562;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_RecoverAccidentXbot (*Recovers an accident xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to be recovered (>0)*)
		RecoveryMode : {REDUND_UNREPLICABLE} USINT; (*0-resume motion after recovery, 1-pause motion(ResumeXbots to continue), 2-clear motion buffer*)
		ShortAxis : {REDUND_UNREPLICABLE} USINT; (*0:resume to default short axis position; 1:resume to previous short axis position*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2862;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ResumeXbots (*unpause xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: all Xbots; >0: specific Xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have resumed motion*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2849;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_RFID_GetXbotRFIDs (*Get all scanned RFIDs and their corresponding xbot IDs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumRFIDs : {REDUND_UNREPLICABLE} USINT; (* Number of RFIDs scanned*)
		RFIDHighs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF UDINT; (* high 32 bits of the scanned RFIDs*)
		RFIDLows : {REDUND_UNREPLICABLE} ARRAY[0..149] OF UDINT; (* low 32 bits of the scanned RFIDs*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* corresponding xbot IDs*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numXbotsToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2631;
		maxNXbotPerFrame : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_RFID_ResetIDs (*Resets absolute xbot IDs for all xbots (PMC must be deactivated first)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2622;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_RotaryMotion (*rotates xbot around the Z axis to a target position*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		BoundaryMode : {REDUND_UNREPLICABLE} SINT; (* 0: high performance, 1: compact*)
		MotionMode : {REDUND_UNREPLICABLE} SINT; (* 0: absolute motion, 1: relative motion *)
		WrapMode : {REDUND_UNREPLICABLE} SINT; (* angle wrapping mode; 0:Absolute position (+/- 100 rotations) 1:positive rotation in the range of [0,2PI) -1: negative rotation in the range of [0,2PI]*)
		Angle : {REDUND_UNREPLICABLE} REAL; (*	target angle of rotation in radians*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* maximum velocity in rads/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* maximum acceleration in rads/second^2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
		mode : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2867;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_RotaryMotionSpin (*spins xbot around the Z axis for a set time*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		BoundaryMode : {REDUND_UNREPLICABLE} SINT; (* 0: high performance, 1: compact*)
		Angle : {REDUND_UNREPLICABLE} REAL; (*	final angle of rotation after spin is complete in radians*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* maximum velocity in rads/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* maximum acceleration in rads/second^2*)
		Duration : {REDUND_UNREPLICABLE} REAL; (* minimum duration of spinning in seconds (0 to spin forever or until StopXbot command sent)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2868;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_RunMacro (*command xbot to run a macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* macro ID# (128 - 191)*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots has finished the macro*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2840;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SaveMacro (*save macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* macro ID# (128 - 191)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 2;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SaveTrajectory (*Send a trajectory file to the PMC, PMC must be in the deactivated state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		TrajID : {REDUND_UNREPLICABLE} USINT; (* Traj ID# (1-64)*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* number of bytes in the G-code file (up to 500,000 bytes)*)
		Axises : {REDUND_UNREPLICABLE} USINT; (* what axises are in the trajectory file: bit0=X; bit1=Y; bit2=Z; bit3=Rx; bit4=Ry; bit5=Rz; bit6=DO (1 means axis selected; 0 means not selected)*)
		TimeInterval : {REDUND_UNREPLICABLE} REAL; (* time interval between positions (seconds)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		Bytes : ARRAY[0..499999] OF SINT; (* the trajectory file as a raw binary*)
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65294;
		maxNByte : DINT := 500000;
		maxNBytePerFrame : SINT := 90;
		mode : SINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ScanXID (*Gets the global ID of a xbot on a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlywayID : {REDUND_UNREPLICABLE} USINT; (* logical ID (>0) of the flyway to scan*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Status : {REDUND_UNREPLICABLE} USINT; (* 1 : valid RFID detected, 0 : invalid*)
		XIDHigh : {REDUND_UNREPLICABLE} UDINT; (* High 32 bits of xbot global ID (left 4 bytes)*)
		XIDLow : {REDUND_UNREPLICABLE} UDINT; (* Low 32 bits of xbot global ID (right 4 bytes)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 61751;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Sector_Activate (*Activate a sector*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		SectorID : {REDUND_UNREPLICABLE} USINT; (* sector ID: >0*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished activating *)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2611;
		mode : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Sector_Deactivate (*Deactivate a sector*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		SectorID : {REDUND_UNREPLICABLE} USINT; (* sector ID: >0*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished activating *)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2611;
		mode : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Sector_GetStatus (*Get the status of a sector*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		SectorID : {REDUND_UNREPLICABLE} USINT; (* sector ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: not defined, 1: disconnected, 2: inactive and fenced, 3: deactivating, 4: stopping, 5: activating, 6: activated and fenced, 7: in operation*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* Number of xbots in the sector*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* IDs of the xbots in the sector*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2613;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Sector_Recover (*Recover a sector, removing the fence around it*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		SectorID : {REDUND_UNREPLICABLE} USINT; (* sector ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2612;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SendDigitalSignalToPMC (*set/reset a digital input to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable the function block*)
		DoID : {REDUND_UNREPLICABLE} USINT; (* digital output (of the PLC fieldbus) ID# [1-128]*)
		Level : {REDUND_UNREPLICABLE} BOOL; (* desired digital signal level*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully set/reset the digital signal*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} DINT;
		BitOffset : {REDUND_UNREPLICABLE} DINT;
		step1 : {REDUND_UNREPLICABLE} USINT;
		step2 : {REDUND_UNREPLICABLE} USINT;
		step3 : {REDUND_UNREPLICABLE} USINT;
		RegVal : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ServiceModeCtrl (*Enter and leave PMC service mode*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0: enter service mode;1: exit service mode*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2569;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetConfiguration (*Sends a configuration file (as raw binary) to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* number of bytes in the configuration file (up to 500,000 bytes) *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
		Bytes : ARRAY[0..499999] OF SINT; (* the configuration file as a raw binary*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65292;
		maxNByte : DINT := 500000;
		maxNBytePerFrame : SINT := 90;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetDateAndTime (*Sets the PMC date and time used for logging *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Year : {REDUND_UNREPLICABLE} UINT; (* year (AD/CE)*)
		Month : {REDUND_UNREPLICABLE} UINT; (* month (one indexed, January = 1)*)
		Day : {REDUND_UNREPLICABLE} UINT; (* day (one indexed, first day of the month = 1)*)
		Hour : {REDUND_UNREPLICABLE} UINT; (* hour (24 hour clock)*)
		Minute : {REDUND_UNREPLICABLE} UINT; (* minute*)
		Second : {REDUND_UNREPLICABLE} UINT; (* second*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2633;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetJerkLimit (*Sets the jerk (rate of acceleration change) limit for a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		AxisID : {REDUND_UNREPLICABLE} USINT; (* axis ID (1: X, 2: Y, 3: Z, 4: Rx, 5: Ry, 6:Rz)*)
		JerkLimit : {REDUND_UNREPLICABLE} REAL; (* Jerk limit (m/s^3 or rad/s^3)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2871;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetXbotOrientation (*Initialize orientation of xbot before activation in absolute ID mode*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (0 = all xbots)*)
		Orientation : {REDUND_UNREPLICABLE} USINT; (* 0-0deg;1-90deg;2-180deg;3-270deg *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2576;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetXbotProperty (*set a xbot property*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to set a property on (up to 14)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..13] OF USINT; (* array of xbot ID#*)
		PropertyID : {REDUND_UNREPLICABLE} ARRAY[0..13] OF USINT; (* array of property IDs; 0: mover type (read only); 1: user configured payload; 2: user configured center of gravity in Z; 3: payload X dimension; 5: payload Y dimension; 7: acceleration limit (read only)   *)
		Value : {REDUND_UNREPLICABLE} ARRAY[0..13] OF REAL; (* array of property values; 1: user configured payload (kilograms); 2: user configured center of gravity in Z (meters); 3: payload X dimension (meters); 5: payload Y dimension (meters)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2845;
		maxNXbots : SINT := 14;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ShortAxisMotion (*move xbot in Z, Rx, Ry, and, Rz*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Execution of the function block begins on a rising edge of this input*)
		cmdLB : {REDUND_UNREPLICABLE} UINT := 0; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT := 0; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT := 0; (* 0:Absolute;1:Relative*)
		Type_ : {REDUND_UNREPLICABLE} USINT := 0; (* 0: Rotation only;1: Planar Rotation*)
		PosZ : {REDUND_UNREPLICABLE} REAL := 0.001; (* Z position in meters*)
		PosRx : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about X axis in radians*)
		PosRy : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about Y axis in radians*)
		PosRz : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about Z axis in radians*)
		VelZ : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity in Z axis in meters/second*)
		VelRx : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity of X axis rotation in radians/second*)
		VelRy : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity of Y axis rotation in radians/second*)
		VelRz : {REDUND_UNREPLICABLE} REAL := 0.5; (* velocity of Z axis rotation in radians/second*)
		Cx : {REDUND_UNREPLICABLE} REAL := 0.0; (* Rotation center in X when type=1*)
		Cy : {REDUND_UNREPLICABLE} REAL := 0.0; (* Rotation center in Y when type=1*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2825;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SingleAxisMotion (*Move a xbot in only one axis *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: Absolute position. 1: relative positioning*)
		Priority : {REDUND_UNREPLICABLE} USINT; (* 0: no priority, 1: high priority; all other xbots that try to enter the path will be blocked until motion is done*)
		AxisID : {REDUND_UNREPLICABLE} USINT; (* axis to move in 1-X, 2-Y, 3-Z, 4-Rx, 5-Ry, 6-Rz *)
		Pos : {REDUND_UNREPLICABLE} REAL; (* position in meters or radians*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* ending velocity in meters/second or radians/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* maximum velocity in meters/second or radians/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* maximum acceleration in meters/second^2 or radians/second^2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2860;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_StartUpPlanarMotorSystem (*activate PMC, levitate all xbots, report number of xbots in system and their ID#s*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in system*)
		Xbot_IDs : {REDUND_UNREPLICABLE} ARRAY[0..98] OF USINT; (* xbot ID#s of xbots in the system*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_ActivateXbots_db : {REDUND_UNREPLICABLE} PMC_ActivateXbots;
		xbot_array_index : {REDUND_UNREPLICABLE} DINT;
		GetXbotIDs : {REDUND_UNREPLICABLE} PMC_GetXbotIDs;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Star_CreateStar (*Define a new star wheel module*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		WheelID : {REDUND_UNREPLICABLE} USINT; (*Wheel ID (>0)*)
		Direction : {REDUND_UNREPLICABLE} USINT; (*Wheel rotation direction (0: clockwise/negative Rz, 1: counterclockwise/position Rz)*)
		MasterXID : {REDUND_UNREPLICABLE} USINT; (*Master Xbot ID (must be virtual xbot 100-127)*)
		DiscRadius : {REDUND_UNREPLICABLE} REAL; (*Wheel radius in meters*)
		MaxDiscSpeed : {REDUND_UNREPLICABLE} REAL; (*Maximum disc rotation speed in rad/s *)
		MaxXbotAcc : {REDUND_UNREPLICABLE} REAL; (*Maximum xbot acceleration in m/s^2*)
		DiscCenterX : {REDUND_UNREPLICABLE} REAL; (*Disc center X coordinate in meters*)
		DiscCenterY : {REDUND_UNREPLICABLE} REAL; (*Disc center Y coordinate in meters*)
		StartX : {REDUND_UNREPLICABLE} REAL; (*Xbot starting location X coordinate in meters*)
		StartY : {REDUND_UNREPLICABLE} REAL; (*Xbot starting location Y coordinate in meters*)
		EndX : {REDUND_UNREPLICABLE} REAL; (*Xbot ending location X coordinate in meters*)
		EndY : {REDUND_UNREPLICABLE} REAL; (*Xbot ending location Y coordinate in meters*)
		SyncStart : {REDUND_UNREPLICABLE} REAL; (*Sync section starting angle in radians *)
		SyncEnd : {REDUND_UNREPLICABLE} REAL; (*Sync section ending angle in radians*)
		NumVials : {REDUND_UNREPLICABLE} USINT; (*Number of vials on the disc (1-100)*)
		VialLocations : {REDUND_UNREPLICABLE} ARRAY[0..99] OF REAL; (*Location of the vials on the disc in radians (CCW is positive)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalVialNum : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numVialsToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : SINT := 0; (* 0: create star wheel *)
		cmdID : UINT := 3091;
		maxNByte : DINT := 100;
		maxNBytePerFrame : SINT := 22;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Star_DeleteStar (*Delete a star wheel module*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		WheelID : {REDUND_UNREPLICABLE} USINT; (* wheel ID:  0 - delete all wheels, >0 - delete single wheel*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 1; (* 1: delete star wheel*)
		cmdID : UINT := 3091;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Star_GetStarStatus (*Get the status of a star wheel module*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		WheelID : {REDUND_UNREPLICABLE} USINT; (* wheel ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		WheelState : {REDUND_UNREPLICABLE} USINT; (*0: not defined, 1: defined, 2: error*)
		EntranceState : {REDUND_UNREPLICABLE} USINT; (*0: not clear, 1: clear*)
		ExitState : {REDUND_UNREPLICABLE} USINT; (*0: no xbot in exit, 1: xbot in exit*)
		ExitXID : {REDUND_UNREPLICABLE} USINT; (*Exit xbot ID*)
		StartX : {REDUND_UNREPLICABLE} REAL; (*Xbot start X coordinate in meters*)
		StartY : {REDUND_UNREPLICABLE} REAL; (*Xbot start Y coordinate in meters*)
		EndX : {REDUND_UNREPLICABLE} REAL; (*Xbot end X coordinate in meters*)
		EndY : {REDUND_UNREPLICABLE} REAL; (*Xbot end Y coordinate in meters*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3092;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Star_SendXbotToStar (*send an xbot to a star wheel module*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		WheelID : {REDUND_UNREPLICABLE} USINT; (* wheel ID: >0 *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3094;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Star_StarExitClear (*Tell a star wheel module that the xbot is clear of the exit*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		WheelID : {REDUND_UNREPLICABLE} USINT; (* Wheel ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3093;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_StopXbots (*stop motion of xbot and clear its buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID#; 0: all xbots; 1: specific xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have stopped moving*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2827;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_StreamModeCtrl (*configure xbot reference streaming*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		Level : USINT;   (* 0:Exit from stream mode;1: Enter stream mode*)
		nXbots : USINT;	(* number of xbots to configure streaming for (up to 9)*)
		XbotID : ARRAY[0..8] OF USINT;	(* array of xbot ID#s*)
		StmID : ARRAY[0..8] OF USINT;	(* stream ID#s*)
		StmAxis : ARRAY[0..8] OF USINT;   (* Bit0: X;Bit1:Y;Bit2:Z;Bit3: Rx; Bit4: Ry; Bit5: Rz*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		StreamStartPosX : ARRAY[0..8] OF REAL;	(* Starting X positions of the xbots *)
		StreamStartPosY : ARRAY[0..8] OF REAL;	(* Starting Y positions of the xbots *)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		numFrames : DINT;
		index : SINT;
		dummy_zero : SINT := 0;
		totalXbotNum : USINT;
	END_VAR

	VAR 
		cmdHB : USINT;
		xIndex : USINT;
		DummyDone : BOOL;
		beginning_index : DINT;
		numXbotsToSend : USINT;
		numXbotsToRead : SINT;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2830;
		maxNXbotPerFrameSend : USINT := 8;
		maxNXbot : USINT := 9;
		maxNXbotPerFrameReply : USINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_SyncMotion (*send linear motion commands to multiple xbots at once*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to send linear move to (up to 4)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* xbot ID#s*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* X positions in meters*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* Y positions in meters*)
		EndVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* Ending velocities in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* maximum velocities in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* maximum accelerations in meters/second^2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2835;
		maxNXbot : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_TareXbot (*reset the xbot weight to zero*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2874;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ThroughputTest (*Measures the 1 ms full duplex throughput of the fieldbus (takes 10-11 ms to finish)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished *)
		Throughput1ms : {REDUND_UNREPLICABLE} DINT; (* Full duplex 1 ms fieldbus throughput *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use *)
	END_VAR
	VAR
		i : {REDUND_UNREPLICABLE} DINT;
		InputByte : {REDUND_UNREPLICABLE} SINT;
		OutputByte : {REDUND_UNREPLICABLE} SINT;
		StartRTCTime : {REDUND_UNREPLICABLE} RTCtime_typ;
		EndRTCTime : {REDUND_UNREPLICABLE} RTCtime_typ;
		StartError : {REDUND_UNREPLICABLE} UINT;
		EndError : {REDUND_UNREPLICABLE} UINT;
		CopyTime_ms : {REDUND_UNREPLICABLE} DINT;
		NumCopies : {REDUND_UNREPLICABLE} DINT := 0;
		NumPerCycle : {REDUND_UNREPLICABLE} DINT := 50;
		SendTime_ms : {REDUND_UNREPLICABLE} DINT := 10;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_VirtualXbotReadPosCtrl (*Enable or disable ReadXbotPos for a virtual xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>=100)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0-enable ReadXbotPos for this virtual xbot,1-disable ReadXbotPos for this virtual xbot  *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		ctrlmode : {REDUND_UNREPLICABLE} USINT := 1;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2873;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_VirtualXbotTeleport (*Teleport a virtual xbot to a given position (virtual xbot must be idle first)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>=100)*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X position (meters)*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y position (meters)*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* Z position (meters)*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* Rx position (radians)*)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* Ry position (radians)*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* Rz position (radians)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2873;
		mode : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilCmdLb (*xbot waits until another xbot performs a command label*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerXID : {REDUND_UNREPLICABLE} USINT; (* Trigger Xbot ID*)
		TriggerType : {REDUND_UNREPLICABLE} USINT; (* 0: Begin;1: End; 2: Execute*)
		TriggerCmdLb : {REDUND_UNREPLICABLE} UINT; (* command label to wait for*)
		LabelType : {REDUND_UNREPLICABLE} USINT; (* 0: Motion Cmd Label;1: Run Macro Cmd Label*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 3;
		count : USINT := 1;
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilDisp (*xbot waits until another xbots reaches a given displacement*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerXID : {REDUND_UNREPLICABLE} USINT; (* Trigger Xbot ID*)
		dispMode : {REDUND_UNREPLICABLE} USINT; (* 0: X only; 1: Y only; 2: posXFactor*X + posYFactor*Y*)
		dispType : {REDUND_UNREPLICABLE} USINT; (* 0: Greater Than;1: Less Than; 2: Positive cross;3: Negative cross*)
		Threshold : {REDUND_UNREPLICABLE} REAL; (* threshold to wait until in meters*)
		posXFactor : {REDUND_UNREPLICABLE} REAL; (* XFactor used for dispMode 2*)
		posYFactor : {REDUND_UNREPLICABLE} REAL; (* YFactor used for dispMode 2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 4;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilFBDI (*xbot waits for a PMC digital input *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerDI : {REDUND_UNREPLICABLE} USINT; (* Trigger Digital ID*)
		TriggerType : {REDUND_UNREPLICABLE} USINT; (* 0: Rising Edge;1: Falling Edge; 2: High Level;3: Low Level*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 2;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilTimeDelay (*xbot waits for a amount of time*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		Delay : {REDUND_UNREPLICABLE} REAL; (* time to wait for in seconds*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 0;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_WaitUntilZone (*xbot waits until the number of xbots in a zone reaches a threshold*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerZoneID : {REDUND_UNREPLICABLE} USINT; (* Trigger Zone ID*)
		TriggerType : {REDUND_UNREPLICABLE} USINT; (* 0: rising edge; 1: falling edge; 2: greater then; 3: less than*)
		Threshold : {REDUND_UNREPLICABLE} USINT; (* number of xbots threshold to wait until*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 7;
		count : USINT := 1;
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_WeighXbot (*Measure the weight of an xbot, averaged over a period of time*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		Duration : {REDUND_UNREPLICABLE} REAL; (* weighting duration (s)*)
		ReturnType : {REDUND_UNREPLICABLE} USINT; (* 0-wait until weighing is complete before returning,1-start weighing only,2-read weighing result only *)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Weighing complete.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Weight : {REDUND_UNREPLICABLE} REAL; (* xbot weight (kilograms)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2869;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_WeighXbotAsync (*Calls WeighXbot with ReturnType = 1 then calls it again with ReturnType = 2 when Done = TRUE*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		Duration : {REDUND_UNREPLICABLE} REAL; (* weighting duration (s)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Weighing complete.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Weight : {REDUND_UNREPLICABLE} REAL; (* xbot weight (kilograms)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		WeighXbotStart : {REDUND_UNREPLICABLE} PMC_WeighXbot;
		WeighXbotRead : {REDUND_UNREPLICABLE} PMC_WeighXbot;
		ResendDelay : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_WriteStream (*Write a reference position/force to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		StmID : {REDUND_UNREPLICABLE} USINT; (* stream ID#s [1-9]*)
		AxisID : {REDUND_UNREPLICABLE} USINT; (* 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		Pos : {REDUND_UNREPLICABLE} REAL; (* reference value; meters for position X/Y/Z; radians for position Rx/Ry/Rz; Newtons for force X/Y/Z; Newton*Meters for force Rx,Ry,Rz*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully wrote reference stream*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} UDINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_XbotPartCtrl (*change the state of the part that the xbot is carrying*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to change part state (up to 150)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* ID#s of xbots to change part state*)
		PartState : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT; (* Part states*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL := FALSE;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3840;
		maxNXbot : UINT := 150;
		maxNXbotPerFrame : SINT := 44;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_XYMotion (*xbot moves in X and Y axes*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: Absolute position. 1: relative positioning*)
		Type_ : {REDUND_UNREPLICABLE} USINT; (* 0: direct straight line; 1: move in X then Y; 2: move in Y then X*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y position in meters*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* ending velocity in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* maximum velocity in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* maximum acceleration in meters/second^2*)
		Radius : REAL := 0.0; (* turn radius of corner if Type = 1 or 2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2824;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_CollisionControl (*Disable/enable Rz collision checks in a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 *)
		DisableRzCheck : {REDUND_UNREPLICABLE} USINT; (* 0 = enable Rz collision check, 1 = disable Rz collision check*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2599;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_DefineZone (*Define the area controlled by a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 *)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: regular zone, >0: intersection zone with # of xbots allowed to enter*)
		BottomLeftX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of bottom left corner of zone (m)*)
		BottomLeftY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of bottom left corner of zone (m)*)
		TopRightX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of right top corner of zone (m)*)
		TopRightY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of right top corner of zone (m)*)
		EnableZLimit : {REDUND_UNREPLICABLE} USINT; (* 0: no Z limit on xbots that enter, 1: enable Z limit*)
		ZLimit : {REDUND_UNREPLICABLE} REAL; (* xbots at height above this will be blocked by fence: ignored if z limit isn't enabled*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2592;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_Fencing (*Activate or deactivate the fence around a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* Zone ID (>0)*)
		Level : {REDUND_UNREPLICABLE} USINT; (* Control level: 0 - fence off, 1 - fence on*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2594;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_GetStatus (*Get the status of a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* Zone ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* Zone State: 0-undefined, 1-active unfenced, 2-deactivating, 3-loading, 4-activating, 5-active fenced*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in the zone*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..38] OF USINT; (* IDs of xbots in the zone*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2595;
		mode : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_GetStatusEx (*Get the status of a zone with extended information*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* Zone ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* Zone State: 0-undefined, 1-active unfenced, 2-deactivating, 3-loading, 4-activating, 5-active fenced*)
		NumXbotsInZone : {REDUND_UNREPLICABLE} USINT; (* number of xbots in the zone*)
		XbotIDsInZone : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* IDs of xbots in the zone*)
		NumXbotsOnBoundary : {REDUND_UNREPLICABLE} USINT; (* number of xbots on boundary of zone*)
		XbotIDsOnBoundary : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* xbot IDs of xbots on boundary*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
		ReadingBoundary : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2595;
		mode : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_OverrideZone (*Change the speed override settings for a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* Zone ID (>0)*)
		OverrideType : {REDUND_UNREPLICABLE} USINT; (* 0-override with ratio,1-override with absolute speed and acceleration limits*)
		SpeedOverrideFactor : {REDUND_UNREPLICABLE} REAL; (* multiplicative factor or absolute limit for xbot speed in the zone (0-2 or m/s)*)
		AccOverrideFactor : {REDUND_UNREPLICABLE} REAL; (* multiplicative factor or absolute limit for xbot acceleration in the zone (0.001-2 or m/s^2)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Zone has finished activating or deactivating*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2596;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_PlaceXbotsEmulation (*Place xbots into a deactivated zone in emulation mode*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 *)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to place (<=9)*)
		MoverType : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT; (*XBot type to place (0 = M3-06,2 = M3-08,4 = M3-09X,5 = M3-09Y,6 = M3-10,8 = M3-11X,9 = M3-11Y,12 = M3-12,14 = M3-13)*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..8] OF REAL; (*X position to place the xbot*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..8] OF REAL; (*Y position to place the xbot*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		xIndex : {REDUND_UNREPLICABLE} USINT;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		mode : USINT := 0;
		cmdID : UINT := 2598;
		maxNXbot : USINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_RemoveXbotsEmulation (*Remove all xbots from a deactivated zone in emulation mode*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		mode : USINT := 1;
		cmdID : UINT := 2598;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Zone_ZoneCtrl (*activate or deactivate a zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* Zone ID (>0)*)
		Level : {REDUND_UNREPLICABLE} USINT; (* Control level: 0 - deactivate zone, 1 - activate zone*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been accepted by PMC*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Zone has finished activating or deactivating*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		index : {REDUND_UNREPLICABLE} SINT;
		dummy_zero : {REDUND_UNREPLICABLE} SINT := 0;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2593;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_GetScanLocation (*get the closest scanning location of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : USINT;	(* Xbot ID# (>0)*)
		Orientation : USINT;	(* 0-East;1-North;2-West;3-South*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		ScanLocationX : REAL;	(* X coordinate of the bottom left corner of the new station (m)*)
		ScanLocationY : REAL; (* Y coordinate of the bottom left corner of the new station (m)*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2627;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_ReadScanStatus (*read a xbot's scan status*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : BOOL;	(* enable function block*)
		XbotID : USINT;	(* xbot ID#*)
	END_VAR
	VAR_OUTPUT
		Valid : BOOL;	(* xbot state is up-to-date, if false the output state is the last known state*)
		ScanStatus : BOOL;   (* false: unscanned, true: scanned*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR 
		curXID : USINT;
		State : USINT;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_ScanMoverID (*Gets the mover ID of a xbot on a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
		FlywayID : USINT;	(* logical ID (>0) of the flyway to scan*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		Status : USINT;	(* 1 : valid RFID detected, 0 : invalid*)
		XIDHigh : UDINT;	(* High 32 bits of xbot global ID (left 4 bytes)*)
		XIDLow : UDINT;	(* Low 32 bits of xbot global ID (right 4 bytes)*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 61751;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverID_Set (*Use the known mover ID of xbots to set the absolute IDs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : USINT;	(* number of xbots to set (up to 150)*)
		XbotID : ARRAY[0..149] OF USINT;	(* ID#s of xbots to set absolute IDs*)
		RFIDHigh : ARRAY[0..149] OF UDINT;	(*  High 32 bits of RFIDs (left 4 bytes)*)
		RFIDLow : ARRAY[0..149] OF UDINT;	(* Low 32 bits of RFIDs (right 4 bytes)*)
		Orientation : ARRAY[0..149] OF USINT;	(* 0-East;1-North;2-West;3-South*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;	(* Xbot(s) motion has completed*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		totalXbotNum : USINT;
		xIndex : USINT;
		beginning_index : USINT;
		numXbotsToSend : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2629;
		maxNXbot : USINT := 150;
		maxNXbotPerFrame : USINT := 8;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetAnyStationXbots (*Gets all the xbots in any state in all the stations*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT 
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		NumBays : UINT;	(* Total number of bays in the system*)
		StationIDs : ARRAY[0..4999] OF USINT;	(* IDs of the station*)
		BayIDs : ARRAY[0..4999] OF USINT;	(* IDs of the bay*)
		XbotIDs : ARRAY[0..4999] OF USINT;	(* IDs of the xbot*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR
		GetAllXbotID : PMC_AppDesign_GetAllStationXbots;
		StateFilterCount : USINT;	(* number xbot states to filter for*)
		XbotStateFilters : ARRAY[0..15] OF USINT;	(* xbot states to filter for*)
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetBayAnyXbot (*gets the ID of a xbot in any state in a station's bay*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
		StationID : USINT;	(* Station ID (>0)*)
		BayID : USINT;	(* Bay ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		XbotID : USINT;	(* Id of the xbot in the station's bay*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR
		GetBayXbotID : PMC_AppDesign_GetBayXbotID;
		StateFilterCount : USINT;	(* number xbot states to filter for*)
		XbotStateFilters : ARRAY[0..15] OF USINT;	(* xbot states to filter for*)
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetBayIdleXbot (*gets the ID of an idle xbot in a station's bay*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
		StationID : USINT;	(* Station ID (>0)*)
		BayID : USINT;	(* Bay ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		XbotID : USINT;	(* Id of the xbot in the station's bay*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR
		GetBayXbotID : PMC_AppDesign_GetBayXbotID;
		StateFilterCount : USINT := 1;	(* number xbot states to filter for*)
		XbotStateFilters : ARRAY[0..15] OF USINT;	(* xbot states to filter for*)
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetStationAnyXbot (*Get the IDs of all xbots in any state in a station*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
		StationID : USINT;	(* Station ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		NumBays : USINT;	(* number of bays in the station*)
		XbotIDs : ARRAY[0..29] OF USINT;	(* IDs of the xbots in the station's bays*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR
		GetStationXbotID : PMC_AppDesign_GetStationXbotIDs;
		StateFilterCount : USINT;	(* number xbot states to filter for*)
		XbotStateFilters : ARRAY[0..15] OF USINT;	(* xbot states to filter for*)
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AppDesign_GetStationIdleXbot (*Get the IDs of all idle xbots in a station*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;	(* Execution of the function block begins on a rising edge of this input.*)
		StationID : USINT;	(* Station ID (>0)*)
	END_VAR
	VAR_OUTPUT
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		NumBays : USINT;	(* number of bays in the station*)
		XbotIDs : ARRAY[0..29] OF USINT;	(* IDs of the xbots in the station's bays*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR
	VAR
		GetStationXbotID : PMC_AppDesign_GetStationXbotIDs;
		StateFilterCount : USINT := 1;	(* number xbot states to filter for*)
		XbotStateFilters : ARRAY[0..15] OF USINT;	(* xbot states to filter for*)
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GroupXYMotion (*send a single linear motion to a group of XBots (creates, bonds, and deletes group all in one step)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : USINT;	(* number of xbots to group and move (up to 32)*)
		XbotID : ARRAY[0..31] OF USINT;	(* xbot ID#s*)
		LeaderXbotID : USINT;	(*xbot to be sent to target position*)
		Mode : USINT;   (* 0: Absolute position. 1: relative positioning*)
		Type_ : USINT;	(* 0: direct straight line; 1: move in X then Y; 2: move in Y then X*)
		PosX : REAL;	(* X position in meters*)
		PosY : REAL;	(* Y position in meters*)
		EndVel : REAL;	(* ending velocity in meters/second*)
		MaxVel : REAL := 1.0;	(* maximum velocity in meters/second*)
		MaxAcc : REAL := 10.0;	(* maximum acceleration in meters/second^2*)
		Radius : REAL := 0.0;	(* turn radius of corner if Type = 1 or 2*)
	END_VAR

	VAR_OUTPUT 
		Ack : BOOL;   (* Command has been accepted by PMC*)
		Done : BOOL;	(* Xbot(s) motion has completed*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		TravelTime : REAL;	(* Time needed for the motion to complete in seconds*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		xbotNum : USINT;
		xIndex : SINT;
		requestEventID : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2884;
		maxNXbot : USINT := 32;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverLabel_GetLabel (*Get mover label of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : USINT;	(* xbot ID# (>0)*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* The function block's output values can be used.*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		MoverLabel : UINT;	(* Mover label assigned to the xbot*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
		cmdHB : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2606;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverLabel_GetXbotID (*search for a xbot based on mover label*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		MoverLabel : UINT;	(* mover label to return the ID for*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		XbotID : USINT;   (* Xbot ID with the mover label*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2608;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MoverLabel_SetLabel (*Set a xbot's mover label*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT 
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : USINT;   (* Xbot ID to set the label for*)
		MoverLabel : UINT;	(* Number to set the label to*)
	END_VAR

	VAR_OUTPUT 
		Done : BOOL;   (* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR 
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : SINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2607;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetAllAccidentLocations (*Get the location of all accidents in the system*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR

	VAR_OUTPUT
		Done : BOOL;	(* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		nAccidents : USINT; (* Number of accidents*)
		AccidentBottomLeftX : ARRAY[0..224] OF REAL;	(* bottom left corner X coordinate of accident zone*)
		AccidentBottomLeftY : ARRAY[0..224] OF REAL;	(* bottom left corner Y coordinate of accident zone*)
		AccidentTopRightX : ARRAY[0..224] OF REAL;	(* top right corner X coordinate of accident zone*)
		AccidentTopRightY : ARRAY[0..224] OF REAL;	(* top right corner Y coordinate of accident zone*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : DINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		beginning_index : DINT;
		numAccidentsToRead : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 2602;
		maxNAccidentPerFrame : USINT := 39;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetFlywayConnectErrorCounts (*Get number of flyway connection errors for each flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR

	VAR_OUTPUT
		Done : BOOL;	(* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		nFlyways : USINT; (* Number of flyways in the system*)
		FlywayStatus : ARRAY[0..199] OF USINT;	(* The status of each flyway*)
		ConnectionErrorCount : ARRAY[0..199] OF UDINT; (* The number of flyway connection errors for each flyway*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : DINT;
		dummy_zero : SINT := 0;
		StatusTemp : USINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		beginning_index : DINT;
		numFlywaysToRead : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 61757;
		maxNFlywayPerFrame : USINT := 8;
	END_VAR
END_FUNCTION_BLOCK


{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMNetErrorCounts (*Get the number of PMNet communication errors for each flyway *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;   (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR

	VAR_OUTPUT
		Done : BOOL;	(* Execution successful. Function block is finished*)
		Busy : BOOL;   (* Function block is active and must continue to be called.*)
		Aborted : BOOL;   (* Command aborted by another command*)
		Error : BOOL;   (* Error occurred during execution.*)
		ErrorID : UINT;   (* Error number*)
		nFlyways : USINT; (* Number of flyways in the system*)
		FlywayNorthConnectionErrorCount : ARRAY[0..199] OF UINT; (* Number of PMNet errors on the north edge*)
		FlywayEastConnectionErrorCount : ARRAY[0..199] OF UINT; (* Number of PMNet errors on the east edge*)
		FlywaySouthConnectionErrorCount : ARRAY[0..199] OF UINT; (* Number of PMNet errors on the south edge*)
		FlywayWestConnectionErrorCount : ARRAY[0..199] OF UINT; (* Number of PMNet errors on the west edge*)
	END_VAR

	VAR_IN_OUT
		PM_Controller : PMControllerType;	(* the planar motor controller to use*)
	END_VAR

	VAR
		PMCFuncInfo : PMCFuncInfoType;
		timeout : UINT;
		index : DINT;
		dummy_zero : SINT := 0;
	END_VAR

	VAR 
		cmdHB : USINT;
		beginning_index : DINT;
		numFlywaysToRead : USINT;
		DummyDone : BOOL;
	END_VAR

	VAR CONSTANT 
		cmdID : UINT := 61764;
		maxNFlywayPerFrame : USINT := 4;
	END_VAR
END_FUNCTION_BLOCK
